import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeAddressesAttributeRequest, DescribeAddressesAttributeResult } from "../models/models_2";
import { deserializeAws_ec2DescribeAddressesAttributeCommand, serializeAws_ec2DescribeAddressesAttributeCommand, } from "../protocols/Aws_ec2";
var DescribeAddressesAttributeCommand = (function (_super) {
    __extends(DescribeAddressesAttributeCommand, _super);
    function DescribeAddressesAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeAddressesAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeAddressesAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeAddressesAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeAddressesAttributeResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeAddressesAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeAddressesAttributeCommand(input, context);
    };
    DescribeAddressesAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeAddressesAttributeCommand(output, context);
    };
    return DescribeAddressesAttributeCommand;
}($Command));
export { DescribeAddressesAttributeCommand };
