import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeregisterInstanceEventNotificationAttributesRequest, DeregisterInstanceEventNotificationAttributesResult, } from "../models/models_2";
import { deserializeAws_ec2DeregisterInstanceEventNotificationAttributesCommand, serializeAws_ec2DeregisterInstanceEventNotificationAttributesCommand, } from "../protocols/Aws_ec2";
var DeregisterInstanceEventNotificationAttributesCommand = (function (_super) {
    __extends(DeregisterInstanceEventNotificationAttributesCommand, _super);
    function DeregisterInstanceEventNotificationAttributesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeregisterInstanceEventNotificationAttributesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeregisterInstanceEventNotificationAttributesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeregisterInstanceEventNotificationAttributesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeregisterInstanceEventNotificationAttributesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeregisterInstanceEventNotificationAttributesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeregisterInstanceEventNotificationAttributesCommand(input, context);
    };
    DeregisterInstanceEventNotificationAttributesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeregisterInstanceEventNotificationAttributesCommand(output, context);
    };
    return DeregisterInstanceEventNotificationAttributesCommand;
}($Command));
export { DeregisterInstanceEventNotificationAttributesCommand };
