import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeprovisionByoipCidrRequest, DeprovisionByoipCidrResult } from "../models/models_2";
import { deserializeAws_ec2DeprovisionByoipCidrCommand, serializeAws_ec2DeprovisionByoipCidrCommand, } from "../protocols/Aws_ec2";
var DeprovisionByoipCidrCommand = (function (_super) {
    __extends(DeprovisionByoipCidrCommand, _super);
    function DeprovisionByoipCidrCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeprovisionByoipCidrCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeprovisionByoipCidrCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeprovisionByoipCidrRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeprovisionByoipCidrResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeprovisionByoipCidrCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeprovisionByoipCidrCommand(input, context);
    };
    DeprovisionByoipCidrCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeprovisionByoipCidrCommand(output, context);
    };
    return DeprovisionByoipCidrCommand;
}($Command));
export { DeprovisionByoipCidrCommand };
