import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteVpnConnectionRouteRequest } from "../models/models_2";
import { deserializeAws_ec2DeleteVpnConnectionRouteCommand, serializeAws_ec2DeleteVpnConnectionRouteCommand, } from "../protocols/Aws_ec2";
var DeleteVpnConnectionRouteCommand = (function (_super) {
    __extends(DeleteVpnConnectionRouteCommand, _super);
    function DeleteVpnConnectionRouteCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteVpnConnectionRouteCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteVpnConnectionRouteCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteVpnConnectionRouteRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteVpnConnectionRouteCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteVpnConnectionRouteCommand(input, context);
    };
    DeleteVpnConnectionRouteCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteVpnConnectionRouteCommand(output, context);
    };
    return DeleteVpnConnectionRouteCommand;
}($Command));
export { DeleteVpnConnectionRouteCommand };
