import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteVpcPeeringConnectionRequest, DeleteVpcPeeringConnectionResult } from "../models/models_2";
import { deserializeAws_ec2DeleteVpcPeeringConnectionCommand, serializeAws_ec2DeleteVpcPeeringConnectionCommand, } from "../protocols/Aws_ec2";
var DeleteVpcPeeringConnectionCommand = (function (_super) {
    __extends(DeleteVpcPeeringConnectionCommand, _super);
    function DeleteVpcPeeringConnectionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteVpcPeeringConnectionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteVpcPeeringConnectionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteVpcPeeringConnectionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteVpcPeeringConnectionResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteVpcPeeringConnectionCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteVpcPeeringConnectionCommand(input, context);
    };
    DeleteVpcPeeringConnectionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteVpcPeeringConnectionCommand(output, context);
    };
    return DeleteVpcPeeringConnectionCommand;
}($Command));
export { DeleteVpcPeeringConnectionCommand };
