import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteVpcEndpointConnectionNotificationsRequest, DeleteVpcEndpointConnectionNotificationsResult, } from "../models/models_2";
import { deserializeAws_ec2DeleteVpcEndpointConnectionNotificationsCommand, serializeAws_ec2DeleteVpcEndpointConnectionNotificationsCommand, } from "../protocols/Aws_ec2";
var DeleteVpcEndpointConnectionNotificationsCommand = (function (_super) {
    __extends(DeleteVpcEndpointConnectionNotificationsCommand, _super);
    function DeleteVpcEndpointConnectionNotificationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteVpcEndpointConnectionNotificationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteVpcEndpointConnectionNotificationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteVpcEndpointConnectionNotificationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteVpcEndpointConnectionNotificationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteVpcEndpointConnectionNotificationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteVpcEndpointConnectionNotificationsCommand(input, context);
    };
    DeleteVpcEndpointConnectionNotificationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteVpcEndpointConnectionNotificationsCommand(output, context);
    };
    return DeleteVpcEndpointConnectionNotificationsCommand;
}($Command));
export { DeleteVpcEndpointConnectionNotificationsCommand };
