import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteTransitGatewayVpcAttachmentRequest, DeleteTransitGatewayVpcAttachmentResult } from "../models/models_2";
import { deserializeAws_ec2DeleteTransitGatewayVpcAttachmentCommand, serializeAws_ec2DeleteTransitGatewayVpcAttachmentCommand, } from "../protocols/Aws_ec2";
var DeleteTransitGatewayVpcAttachmentCommand = (function (_super) {
    __extends(DeleteTransitGatewayVpcAttachmentCommand, _super);
    function DeleteTransitGatewayVpcAttachmentCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteTransitGatewayVpcAttachmentCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteTransitGatewayVpcAttachmentCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteTransitGatewayVpcAttachmentRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteTransitGatewayVpcAttachmentResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteTransitGatewayVpcAttachmentCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteTransitGatewayVpcAttachmentCommand(input, context);
    };
    DeleteTransitGatewayVpcAttachmentCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteTransitGatewayVpcAttachmentCommand(output, context);
    };
    return DeleteTransitGatewayVpcAttachmentCommand;
}($Command));
export { DeleteTransitGatewayVpcAttachmentCommand };
