import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteTransitGatewayRouteTableRequest, DeleteTransitGatewayRouteTableResult } from "../models/models_2";
import { deserializeAws_ec2DeleteTransitGatewayRouteTableCommand, serializeAws_ec2DeleteTransitGatewayRouteTableCommand, } from "../protocols/Aws_ec2";
var DeleteTransitGatewayRouteTableCommand = (function (_super) {
    __extends(DeleteTransitGatewayRouteTableCommand, _super);
    function DeleteTransitGatewayRouteTableCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteTransitGatewayRouteTableCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteTransitGatewayRouteTableCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteTransitGatewayRouteTableRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteTransitGatewayRouteTableResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteTransitGatewayRouteTableCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteTransitGatewayRouteTableCommand(input, context);
    };
    DeleteTransitGatewayRouteTableCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteTransitGatewayRouteTableCommand(output, context);
    };
    return DeleteTransitGatewayRouteTableCommand;
}($Command));
export { DeleteTransitGatewayRouteTableCommand };
