import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteTransitGatewayPeeringAttachmentRequest, DeleteTransitGatewayPeeringAttachmentResult, } from "../models/models_2";
import { deserializeAws_ec2DeleteTransitGatewayPeeringAttachmentCommand, serializeAws_ec2DeleteTransitGatewayPeeringAttachmentCommand, } from "../protocols/Aws_ec2";
var DeleteTransitGatewayPeeringAttachmentCommand = (function (_super) {
    __extends(DeleteTransitGatewayPeeringAttachmentCommand, _super);
    function DeleteTransitGatewayPeeringAttachmentCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteTransitGatewayPeeringAttachmentCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteTransitGatewayPeeringAttachmentCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteTransitGatewayPeeringAttachmentRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteTransitGatewayPeeringAttachmentResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteTransitGatewayPeeringAttachmentCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteTransitGatewayPeeringAttachmentCommand(input, context);
    };
    DeleteTransitGatewayPeeringAttachmentCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteTransitGatewayPeeringAttachmentCommand(output, context);
    };
    return DeleteTransitGatewayPeeringAttachmentCommand;
}($Command));
export { DeleteTransitGatewayPeeringAttachmentCommand };
