import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteTransitGatewayConnectPeerRequest, DeleteTransitGatewayConnectPeerResult } from "../models/models_2";
import { deserializeAws_ec2DeleteTransitGatewayConnectPeerCommand, serializeAws_ec2DeleteTransitGatewayConnectPeerCommand, } from "../protocols/Aws_ec2";
var DeleteTransitGatewayConnectPeerCommand = (function (_super) {
    __extends(DeleteTransitGatewayConnectPeerCommand, _super);
    function DeleteTransitGatewayConnectPeerCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteTransitGatewayConnectPeerCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteTransitGatewayConnectPeerCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteTransitGatewayConnectPeerRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteTransitGatewayConnectPeerResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteTransitGatewayConnectPeerCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteTransitGatewayConnectPeerCommand(input, context);
    };
    DeleteTransitGatewayConnectPeerCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteTransitGatewayConnectPeerCommand(output, context);
    };
    return DeleteTransitGatewayConnectPeerCommand;
}($Command));
export { DeleteTransitGatewayConnectPeerCommand };
