import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteTransitGatewayRequest, DeleteTransitGatewayResult } from "../models/models_2";
import { deserializeAws_ec2DeleteTransitGatewayCommand, serializeAws_ec2DeleteTransitGatewayCommand, } from "../protocols/Aws_ec2";
var DeleteTransitGatewayCommand = (function (_super) {
    __extends(DeleteTransitGatewayCommand, _super);
    function DeleteTransitGatewayCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteTransitGatewayCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteTransitGatewayCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteTransitGatewayRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteTransitGatewayResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteTransitGatewayCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteTransitGatewayCommand(input, context);
    };
    DeleteTransitGatewayCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteTransitGatewayCommand(output, context);
    };
    return DeleteTransitGatewayCommand;
}($Command));
export { DeleteTransitGatewayCommand };
