import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteTrafficMirrorTargetRequest, DeleteTrafficMirrorTargetResult } from "../models/models_2";
import { deserializeAws_ec2DeleteTrafficMirrorTargetCommand, serializeAws_ec2DeleteTrafficMirrorTargetCommand, } from "../protocols/Aws_ec2";
var DeleteTrafficMirrorTargetCommand = (function (_super) {
    __extends(DeleteTrafficMirrorTargetCommand, _super);
    function DeleteTrafficMirrorTargetCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteTrafficMirrorTargetCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteTrafficMirrorTargetCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteTrafficMirrorTargetRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteTrafficMirrorTargetResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteTrafficMirrorTargetCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteTrafficMirrorTargetCommand(input, context);
    };
    DeleteTrafficMirrorTargetCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteTrafficMirrorTargetCommand(output, context);
    };
    return DeleteTrafficMirrorTargetCommand;
}($Command));
export { DeleteTrafficMirrorTargetCommand };
