import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteTrafficMirrorFilterRequest, DeleteTrafficMirrorFilterResult } from "../models/models_2";
import { deserializeAws_ec2DeleteTrafficMirrorFilterCommand, serializeAws_ec2DeleteTrafficMirrorFilterCommand, } from "../protocols/Aws_ec2";
var DeleteTrafficMirrorFilterCommand = (function (_super) {
    __extends(DeleteTrafficMirrorFilterCommand, _super);
    function DeleteTrafficMirrorFilterCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteTrafficMirrorFilterCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteTrafficMirrorFilterCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteTrafficMirrorFilterRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteTrafficMirrorFilterResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteTrafficMirrorFilterCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteTrafficMirrorFilterCommand(input, context);
    };
    DeleteTrafficMirrorFilterCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteTrafficMirrorFilterCommand(output, context);
    };
    return DeleteTrafficMirrorFilterCommand;
}($Command));
export { DeleteTrafficMirrorFilterCommand };
