import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteSubnetCidrReservationRequest, DeleteSubnetCidrReservationResult } from "../models/models_2";
import { deserializeAws_ec2DeleteSubnetCidrReservationCommand, serializeAws_ec2DeleteSubnetCidrReservationCommand, } from "../protocols/Aws_ec2";
var DeleteSubnetCidrReservationCommand = (function (_super) {
    __extends(DeleteSubnetCidrReservationCommand, _super);
    function DeleteSubnetCidrReservationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteSubnetCidrReservationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteSubnetCidrReservationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteSubnetCidrReservationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteSubnetCidrReservationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteSubnetCidrReservationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteSubnetCidrReservationCommand(input, context);
    };
    DeleteSubnetCidrReservationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteSubnetCidrReservationCommand(output, context);
    };
    return DeleteSubnetCidrReservationCommand;
}($Command));
export { DeleteSubnetCidrReservationCommand };
