import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteSecurityGroupRequest } from "../models/models_2";
import { deserializeAws_ec2DeleteSecurityGroupCommand, serializeAws_ec2DeleteSecurityGroupCommand, } from "../protocols/Aws_ec2";
var DeleteSecurityGroupCommand = (function (_super) {
    __extends(DeleteSecurityGroupCommand, _super);
    function DeleteSecurityGroupCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteSecurityGroupCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteSecurityGroupCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteSecurityGroupRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteSecurityGroupCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteSecurityGroupCommand(input, context);
    };
    DeleteSecurityGroupCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteSecurityGroupCommand(output, context);
    };
    return DeleteSecurityGroupCommand;
}($Command));
export { DeleteSecurityGroupCommand };
