import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteNetworkInterfaceRequest } from "../models/models_2";
import { deserializeAws_ec2DeleteNetworkInterfaceCommand, serializeAws_ec2DeleteNetworkInterfaceCommand, } from "../protocols/Aws_ec2";
var DeleteNetworkInterfaceCommand = (function (_super) {
    __extends(DeleteNetworkInterfaceCommand, _super);
    function DeleteNetworkInterfaceCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteNetworkInterfaceCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteNetworkInterfaceCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteNetworkInterfaceRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteNetworkInterfaceCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteNetworkInterfaceCommand(input, context);
    };
    DeleteNetworkInterfaceCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteNetworkInterfaceCommand(output, context);
    };
    return DeleteNetworkInterfaceCommand;
}($Command));
export { DeleteNetworkInterfaceCommand };
