import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteManagedPrefixListRequest, DeleteManagedPrefixListResult } from "../models/models_2";
import { deserializeAws_ec2DeleteManagedPrefixListCommand, serializeAws_ec2DeleteManagedPrefixListCommand, } from "../protocols/Aws_ec2";
var DeleteManagedPrefixListCommand = (function (_super) {
    __extends(DeleteManagedPrefixListCommand, _super);
    function DeleteManagedPrefixListCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteManagedPrefixListCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteManagedPrefixListCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteManagedPrefixListRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteManagedPrefixListResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteManagedPrefixListCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteManagedPrefixListCommand(input, context);
    };
    DeleteManagedPrefixListCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteManagedPrefixListCommand(output, context);
    };
    return DeleteManagedPrefixListCommand;
}($Command));
export { DeleteManagedPrefixListCommand };
