import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteLocalGatewayRouteRequest, DeleteLocalGatewayRouteResult } from "../models/models_2";
import { deserializeAws_ec2DeleteLocalGatewayRouteCommand, serializeAws_ec2DeleteLocalGatewayRouteCommand, } from "../protocols/Aws_ec2";
var DeleteLocalGatewayRouteCommand = (function (_super) {
    __extends(DeleteLocalGatewayRouteCommand, _super);
    function DeleteLocalGatewayRouteCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteLocalGatewayRouteCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteLocalGatewayRouteCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteLocalGatewayRouteRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteLocalGatewayRouteResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteLocalGatewayRouteCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteLocalGatewayRouteCommand(input, context);
    };
    DeleteLocalGatewayRouteCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteLocalGatewayRouteCommand(output, context);
    };
    return DeleteLocalGatewayRouteCommand;
}($Command));
export { DeleteLocalGatewayRouteCommand };
