import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteLaunchTemplateVersionsRequest, DeleteLaunchTemplateVersionsResult } from "../models/models_2";
import { deserializeAws_ec2DeleteLaunchTemplateVersionsCommand, serializeAws_ec2DeleteLaunchTemplateVersionsCommand, } from "../protocols/Aws_ec2";
var DeleteLaunchTemplateVersionsCommand = (function (_super) {
    __extends(DeleteLaunchTemplateVersionsCommand, _super);
    function DeleteLaunchTemplateVersionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteLaunchTemplateVersionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteLaunchTemplateVersionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteLaunchTemplateVersionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteLaunchTemplateVersionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteLaunchTemplateVersionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteLaunchTemplateVersionsCommand(input, context);
    };
    DeleteLaunchTemplateVersionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteLaunchTemplateVersionsCommand(output, context);
    };
    return DeleteLaunchTemplateVersionsCommand;
}($Command));
export { DeleteLaunchTemplateVersionsCommand };
