import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteKeyPairRequest } from "../models/models_2";
import { deserializeAws_ec2DeleteKeyPairCommand, serializeAws_ec2DeleteKeyPairCommand } from "../protocols/Aws_ec2";
var DeleteKeyPairCommand = (function (_super) {
    __extends(DeleteKeyPairCommand, _super);
    function DeleteKeyPairCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteKeyPairCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteKeyPairCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteKeyPairRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteKeyPairCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteKeyPairCommand(input, context);
    };
    DeleteKeyPairCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteKeyPairCommand(output, context);
    };
    return DeleteKeyPairCommand;
}($Command));
export { DeleteKeyPairCommand };
