import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteFlowLogsRequest, DeleteFlowLogsResult } from "../models/models_2";
import { deserializeAws_ec2DeleteFlowLogsCommand, serializeAws_ec2DeleteFlowLogsCommand } from "../protocols/Aws_ec2";
var DeleteFlowLogsCommand = (function (_super) {
    __extends(DeleteFlowLogsCommand, _super);
    function DeleteFlowLogsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteFlowLogsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteFlowLogsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteFlowLogsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteFlowLogsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteFlowLogsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteFlowLogsCommand(input, context);
    };
    DeleteFlowLogsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteFlowLogsCommand(output, context);
    };
    return DeleteFlowLogsCommand;
}($Command));
export { DeleteFlowLogsCommand };
