import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteEgressOnlyInternetGatewayRequest, DeleteEgressOnlyInternetGatewayResult } from "../models/models_2";
import { deserializeAws_ec2DeleteEgressOnlyInternetGatewayCommand, serializeAws_ec2DeleteEgressOnlyInternetGatewayCommand, } from "../protocols/Aws_ec2";
var DeleteEgressOnlyInternetGatewayCommand = (function (_super) {
    __extends(DeleteEgressOnlyInternetGatewayCommand, _super);
    function DeleteEgressOnlyInternetGatewayCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteEgressOnlyInternetGatewayCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteEgressOnlyInternetGatewayCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteEgressOnlyInternetGatewayRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteEgressOnlyInternetGatewayResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteEgressOnlyInternetGatewayCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteEgressOnlyInternetGatewayCommand(input, context);
    };
    DeleteEgressOnlyInternetGatewayCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteEgressOnlyInternetGatewayCommand(output, context);
    };
    return DeleteEgressOnlyInternetGatewayCommand;
}($Command));
export { DeleteEgressOnlyInternetGatewayCommand };
