import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteClientVpnRouteRequest, DeleteClientVpnRouteResult } from "../models/models_2";
import { deserializeAws_ec2DeleteClientVpnRouteCommand, serializeAws_ec2DeleteClientVpnRouteCommand, } from "../protocols/Aws_ec2";
var DeleteClientVpnRouteCommand = (function (_super) {
    __extends(DeleteClientVpnRouteCommand, _super);
    function DeleteClientVpnRouteCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteClientVpnRouteCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteClientVpnRouteCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteClientVpnRouteRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteClientVpnRouteResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteClientVpnRouteCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteClientVpnRouteCommand(input, context);
    };
    DeleteClientVpnRouteCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteClientVpnRouteCommand(output, context);
    };
    return DeleteClientVpnRouteCommand;
}($Command));
export { DeleteClientVpnRouteCommand };
