import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateVpcEndpointServiceConfigurationRequest, CreateVpcEndpointServiceConfigurationResult, } from "../models/models_2";
import { deserializeAws_ec2CreateVpcEndpointServiceConfigurationCommand, serializeAws_ec2CreateVpcEndpointServiceConfigurationCommand, } from "../protocols/Aws_ec2";
var CreateVpcEndpointServiceConfigurationCommand = (function (_super) {
    __extends(CreateVpcEndpointServiceConfigurationCommand, _super);
    function CreateVpcEndpointServiceConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateVpcEndpointServiceConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateVpcEndpointServiceConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateVpcEndpointServiceConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateVpcEndpointServiceConfigurationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateVpcEndpointServiceConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateVpcEndpointServiceConfigurationCommand(input, context);
    };
    CreateVpcEndpointServiceConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateVpcEndpointServiceConfigurationCommand(output, context);
    };
    return CreateVpcEndpointServiceConfigurationCommand;
}($Command));
export { CreateVpcEndpointServiceConfigurationCommand };
