import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateVpcEndpointRequest, CreateVpcEndpointResult } from "../models/models_2";
import { deserializeAws_ec2CreateVpcEndpointCommand, serializeAws_ec2CreateVpcEndpointCommand, } from "../protocols/Aws_ec2";
var CreateVpcEndpointCommand = (function (_super) {
    __extends(CreateVpcEndpointCommand, _super);
    function CreateVpcEndpointCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateVpcEndpointCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateVpcEndpointCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateVpcEndpointRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateVpcEndpointResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateVpcEndpointCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateVpcEndpointCommand(input, context);
    };
    CreateVpcEndpointCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateVpcEndpointCommand(output, context);
    };
    return CreateVpcEndpointCommand;
}($Command));
export { CreateVpcEndpointCommand };
