import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateTransitGatewayRouteTableRequest, CreateTransitGatewayRouteTableResult } from "../models/models_2";
import { deserializeAws_ec2CreateTransitGatewayRouteTableCommand, serializeAws_ec2CreateTransitGatewayRouteTableCommand, } from "../protocols/Aws_ec2";
var CreateTransitGatewayRouteTableCommand = (function (_super) {
    __extends(CreateTransitGatewayRouteTableCommand, _super);
    function CreateTransitGatewayRouteTableCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateTransitGatewayRouteTableCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateTransitGatewayRouteTableCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateTransitGatewayRouteTableRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateTransitGatewayRouteTableResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateTransitGatewayRouteTableCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateTransitGatewayRouteTableCommand(input, context);
    };
    CreateTransitGatewayRouteTableCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateTransitGatewayRouteTableCommand(output, context);
    };
    return CreateTransitGatewayRouteTableCommand;
}($Command));
export { CreateTransitGatewayRouteTableCommand };
