import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateTransitGatewayRouteRequest, CreateTransitGatewayRouteResult } from "../models/models_2";
import { deserializeAws_ec2CreateTransitGatewayRouteCommand, serializeAws_ec2CreateTransitGatewayRouteCommand, } from "../protocols/Aws_ec2";
var CreateTransitGatewayRouteCommand = (function (_super) {
    __extends(CreateTransitGatewayRouteCommand, _super);
    function CreateTransitGatewayRouteCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateTransitGatewayRouteCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateTransitGatewayRouteCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateTransitGatewayRouteRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateTransitGatewayRouteResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateTransitGatewayRouteCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateTransitGatewayRouteCommand(input, context);
    };
    CreateTransitGatewayRouteCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateTransitGatewayRouteCommand(output, context);
    };
    return CreateTransitGatewayRouteCommand;
}($Command));
export { CreateTransitGatewayRouteCommand };
