import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateTransitGatewayPrefixListReferenceRequest, CreateTransitGatewayPrefixListReferenceResult, } from "../models/models_2";
import { deserializeAws_ec2CreateTransitGatewayPrefixListReferenceCommand, serializeAws_ec2CreateTransitGatewayPrefixListReferenceCommand, } from "../protocols/Aws_ec2";
var CreateTransitGatewayPrefixListReferenceCommand = (function (_super) {
    __extends(CreateTransitGatewayPrefixListReferenceCommand, _super);
    function CreateTransitGatewayPrefixListReferenceCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateTransitGatewayPrefixListReferenceCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateTransitGatewayPrefixListReferenceCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateTransitGatewayPrefixListReferenceRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateTransitGatewayPrefixListReferenceResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateTransitGatewayPrefixListReferenceCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateTransitGatewayPrefixListReferenceCommand(input, context);
    };
    CreateTransitGatewayPrefixListReferenceCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateTransitGatewayPrefixListReferenceCommand(output, context);
    };
    return CreateTransitGatewayPrefixListReferenceCommand;
}($Command));
export { CreateTransitGatewayPrefixListReferenceCommand };
