import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateTransitGatewayPeeringAttachmentRequest, CreateTransitGatewayPeeringAttachmentResult, } from "../models/models_2";
import { deserializeAws_ec2CreateTransitGatewayPeeringAttachmentCommand, serializeAws_ec2CreateTransitGatewayPeeringAttachmentCommand, } from "../protocols/Aws_ec2";
var CreateTransitGatewayPeeringAttachmentCommand = (function (_super) {
    __extends(CreateTransitGatewayPeeringAttachmentCommand, _super);
    function CreateTransitGatewayPeeringAttachmentCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateTransitGatewayPeeringAttachmentCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateTransitGatewayPeeringAttachmentCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateTransitGatewayPeeringAttachmentRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateTransitGatewayPeeringAttachmentResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateTransitGatewayPeeringAttachmentCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateTransitGatewayPeeringAttachmentCommand(input, context);
    };
    CreateTransitGatewayPeeringAttachmentCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateTransitGatewayPeeringAttachmentCommand(output, context);
    };
    return CreateTransitGatewayPeeringAttachmentCommand;
}($Command));
export { CreateTransitGatewayPeeringAttachmentCommand };
