import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateTrafficMirrorFilterRuleRequest, CreateTrafficMirrorFilterRuleResult } from "../models/models_1";
import { deserializeAws_ec2CreateTrafficMirrorFilterRuleCommand, serializeAws_ec2CreateTrafficMirrorFilterRuleCommand, } from "../protocols/Aws_ec2";
var CreateTrafficMirrorFilterRuleCommand = (function (_super) {
    __extends(CreateTrafficMirrorFilterRuleCommand, _super);
    function CreateTrafficMirrorFilterRuleCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateTrafficMirrorFilterRuleCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateTrafficMirrorFilterRuleCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateTrafficMirrorFilterRuleRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateTrafficMirrorFilterRuleResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateTrafficMirrorFilterRuleCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateTrafficMirrorFilterRuleCommand(input, context);
    };
    CreateTrafficMirrorFilterRuleCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateTrafficMirrorFilterRuleCommand(output, context);
    };
    return CreateTrafficMirrorFilterRuleCommand;
}($Command));
export { CreateTrafficMirrorFilterRuleCommand };
