import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateSubnetCidrReservationRequest, CreateSubnetCidrReservationResult } from "../models/models_1";
import { deserializeAws_ec2CreateSubnetCidrReservationCommand, serializeAws_ec2CreateSubnetCidrReservationCommand, } from "../protocols/Aws_ec2";
var CreateSubnetCidrReservationCommand = (function (_super) {
    __extends(CreateSubnetCidrReservationCommand, _super);
    function CreateSubnetCidrReservationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateSubnetCidrReservationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateSubnetCidrReservationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateSubnetCidrReservationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateSubnetCidrReservationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateSubnetCidrReservationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateSubnetCidrReservationCommand(input, context);
    };
    CreateSubnetCidrReservationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateSubnetCidrReservationCommand(output, context);
    };
    return CreateSubnetCidrReservationCommand;
}($Command));
export { CreateSubnetCidrReservationCommand };
