import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateSpotDatafeedSubscriptionRequest, CreateSpotDatafeedSubscriptionResult } from "../models/models_1";
import { deserializeAws_ec2CreateSpotDatafeedSubscriptionCommand, serializeAws_ec2CreateSpotDatafeedSubscriptionCommand, } from "../protocols/Aws_ec2";
var CreateSpotDatafeedSubscriptionCommand = (function (_super) {
    __extends(CreateSpotDatafeedSubscriptionCommand, _super);
    function CreateSpotDatafeedSubscriptionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateSpotDatafeedSubscriptionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateSpotDatafeedSubscriptionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateSpotDatafeedSubscriptionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateSpotDatafeedSubscriptionResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateSpotDatafeedSubscriptionCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateSpotDatafeedSubscriptionCommand(input, context);
    };
    CreateSpotDatafeedSubscriptionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateSpotDatafeedSubscriptionCommand(output, context);
    };
    return CreateSpotDatafeedSubscriptionCommand;
}($Command));
export { CreateSpotDatafeedSubscriptionCommand };
