import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateRouteRequest, CreateRouteResult } from "../models/models_1";
import { deserializeAws_ec2CreateRouteCommand, serializeAws_ec2CreateRouteCommand } from "../protocols/Aws_ec2";
var CreateRouteCommand = (function (_super) {
    __extends(CreateRouteCommand, _super);
    function CreateRouteCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateRouteCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateRouteCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateRouteRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateRouteResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateRouteCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateRouteCommand(input, context);
    };
    CreateRouteCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateRouteCommand(output, context);
    };
    return CreateRouteCommand;
}($Command));
export { CreateRouteCommand };
