import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateNetworkInterfacePermissionRequest, CreateNetworkInterfacePermissionResult } from "../models/models_1";
import { deserializeAws_ec2CreateNetworkInterfacePermissionCommand, serializeAws_ec2CreateNetworkInterfacePermissionCommand, } from "../protocols/Aws_ec2";
var CreateNetworkInterfacePermissionCommand = (function (_super) {
    __extends(CreateNetworkInterfacePermissionCommand, _super);
    function CreateNetworkInterfacePermissionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateNetworkInterfacePermissionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateNetworkInterfacePermissionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateNetworkInterfacePermissionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateNetworkInterfacePermissionResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateNetworkInterfacePermissionCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateNetworkInterfacePermissionCommand(input, context);
    };
    CreateNetworkInterfacePermissionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateNetworkInterfacePermissionCommand(output, context);
    };
    return CreateNetworkInterfacePermissionCommand;
}($Command));
export { CreateNetworkInterfacePermissionCommand };
