import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateNetworkInsightsAccessScopeRequest, CreateNetworkInsightsAccessScopeResult } from "../models/models_1";
import { deserializeAws_ec2CreateNetworkInsightsAccessScopeCommand, serializeAws_ec2CreateNetworkInsightsAccessScopeCommand, } from "../protocols/Aws_ec2";
var CreateNetworkInsightsAccessScopeCommand = (function (_super) {
    __extends(CreateNetworkInsightsAccessScopeCommand, _super);
    function CreateNetworkInsightsAccessScopeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateNetworkInsightsAccessScopeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateNetworkInsightsAccessScopeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateNetworkInsightsAccessScopeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateNetworkInsightsAccessScopeResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateNetworkInsightsAccessScopeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateNetworkInsightsAccessScopeCommand(input, context);
    };
    CreateNetworkInsightsAccessScopeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateNetworkInsightsAccessScopeCommand(output, context);
    };
    return CreateNetworkInsightsAccessScopeCommand;
}($Command));
export { CreateNetworkInsightsAccessScopeCommand };
