import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateLocalGatewayRouteRequest, CreateLocalGatewayRouteResult } from "../models/models_1";
import { deserializeAws_ec2CreateLocalGatewayRouteCommand, serializeAws_ec2CreateLocalGatewayRouteCommand, } from "../protocols/Aws_ec2";
var CreateLocalGatewayRouteCommand = (function (_super) {
    __extends(CreateLocalGatewayRouteCommand, _super);
    function CreateLocalGatewayRouteCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateLocalGatewayRouteCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateLocalGatewayRouteCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateLocalGatewayRouteRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateLocalGatewayRouteResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateLocalGatewayRouteCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateLocalGatewayRouteCommand(input, context);
    };
    CreateLocalGatewayRouteCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateLocalGatewayRouteCommand(output, context);
    };
    return CreateLocalGatewayRouteCommand;
}($Command));
export { CreateLocalGatewayRouteCommand };
