import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateLaunchTemplateVersionRequest, CreateLaunchTemplateVersionResult } from "../models/models_1";
import { deserializeAws_ec2CreateLaunchTemplateVersionCommand, serializeAws_ec2CreateLaunchTemplateVersionCommand, } from "../protocols/Aws_ec2";
var CreateLaunchTemplateVersionCommand = (function (_super) {
    __extends(CreateLaunchTemplateVersionCommand, _super);
    function CreateLaunchTemplateVersionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateLaunchTemplateVersionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateLaunchTemplateVersionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateLaunchTemplateVersionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateLaunchTemplateVersionResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateLaunchTemplateVersionCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateLaunchTemplateVersionCommand(input, context);
    };
    CreateLaunchTemplateVersionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateLaunchTemplateVersionCommand(output, context);
    };
    return CreateLaunchTemplateVersionCommand;
}($Command));
export { CreateLaunchTemplateVersionCommand };
