import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateIpamPoolRequest, CreateIpamPoolResult } from "../models/models_1";
import { deserializeAws_ec2CreateIpamPoolCommand, serializeAws_ec2CreateIpamPoolCommand } from "../protocols/Aws_ec2";
var CreateIpamPoolCommand = (function (_super) {
    __extends(CreateIpamPoolCommand, _super);
    function CreateIpamPoolCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateIpamPoolCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateIpamPoolCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateIpamPoolRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateIpamPoolResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateIpamPoolCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateIpamPoolCommand(input, context);
    };
    CreateIpamPoolCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateIpamPoolCommand(output, context);
    };
    return CreateIpamPoolCommand;
}($Command));
export { CreateIpamPoolCommand };
