import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateImageRequest, CreateImageResult } from "../models/models_1";
import { deserializeAws_ec2CreateImageCommand, serializeAws_ec2CreateImageCommand } from "../protocols/Aws_ec2";
var CreateImageCommand = (function (_super) {
    __extends(CreateImageCommand, _super);
    function CreateImageCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateImageCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateImageCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateImageRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateImageResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateImageCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateImageCommand(input, context);
    };
    CreateImageCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateImageCommand(output, context);
    };
    return CreateImageCommand;
}($Command));
export { CreateImageCommand };
