import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateDefaultSubnetRequest, CreateDefaultSubnetResult } from "../models/models_0";
import { deserializeAws_ec2CreateDefaultSubnetCommand, serializeAws_ec2CreateDefaultSubnetCommand, } from "../protocols/Aws_ec2";
var CreateDefaultSubnetCommand = (function (_super) {
    __extends(CreateDefaultSubnetCommand, _super);
    function CreateDefaultSubnetCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateDefaultSubnetCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateDefaultSubnetCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateDefaultSubnetRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateDefaultSubnetResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateDefaultSubnetCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateDefaultSubnetCommand(input, context);
    };
    CreateDefaultSubnetCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateDefaultSubnetCommand(output, context);
    };
    return CreateDefaultSubnetCommand;
}($Command));
export { CreateDefaultSubnetCommand };
