import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ConfirmProductInstanceRequest, ConfirmProductInstanceResult } from "../models/models_0";
import { deserializeAws_ec2ConfirmProductInstanceCommand, serializeAws_ec2ConfirmProductInstanceCommand, } from "../protocols/Aws_ec2";
var ConfirmProductInstanceCommand = (function (_super) {
    __extends(ConfirmProductInstanceCommand, _super);
    function ConfirmProductInstanceCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ConfirmProductInstanceCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ConfirmProductInstanceCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ConfirmProductInstanceRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ConfirmProductInstanceResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ConfirmProductInstanceCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ConfirmProductInstanceCommand(input, context);
    };
    ConfirmProductInstanceCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ConfirmProductInstanceCommand(output, context);
    };
    return ConfirmProductInstanceCommand;
}($Command));
export { ConfirmProductInstanceCommand };
