import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CancelConversionRequest } from "../models/models_0";
import { deserializeAws_ec2CancelConversionTaskCommand, serializeAws_ec2CancelConversionTaskCommand, } from "../protocols/Aws_ec2";
var CancelConversionTaskCommand = (function (_super) {
    __extends(CancelConversionTaskCommand, _super);
    function CancelConversionTaskCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CancelConversionTaskCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CancelConversionTaskCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CancelConversionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CancelConversionTaskCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CancelConversionTaskCommand(input, context);
    };
    CancelConversionTaskCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CancelConversionTaskCommand(output, context);
    };
    return CancelConversionTaskCommand;
}($Command));
export { CancelConversionTaskCommand };
