import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AuthorizeSecurityGroupIngressRequest, AuthorizeSecurityGroupIngressResult } from "../models/models_0";
import { deserializeAws_ec2AuthorizeSecurityGroupIngressCommand, serializeAws_ec2AuthorizeSecurityGroupIngressCommand, } from "../protocols/Aws_ec2";
var AuthorizeSecurityGroupIngressCommand = (function (_super) {
    __extends(AuthorizeSecurityGroupIngressCommand, _super);
    function AuthorizeSecurityGroupIngressCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AuthorizeSecurityGroupIngressCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AuthorizeSecurityGroupIngressCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AuthorizeSecurityGroupIngressRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AuthorizeSecurityGroupIngressResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AuthorizeSecurityGroupIngressCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AuthorizeSecurityGroupIngressCommand(input, context);
    };
    AuthorizeSecurityGroupIngressCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AuthorizeSecurityGroupIngressCommand(output, context);
    };
    return AuthorizeSecurityGroupIngressCommand;
}($Command));
export { AuthorizeSecurityGroupIngressCommand };
