import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AuthorizeClientVpnIngressRequest, AuthorizeClientVpnIngressResult } from "../models/models_0";
import { deserializeAws_ec2AuthorizeClientVpnIngressCommand, serializeAws_ec2AuthorizeClientVpnIngressCommand, } from "../protocols/Aws_ec2";
var AuthorizeClientVpnIngressCommand = (function (_super) {
    __extends(AuthorizeClientVpnIngressCommand, _super);
    function AuthorizeClientVpnIngressCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AuthorizeClientVpnIngressCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AuthorizeClientVpnIngressCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AuthorizeClientVpnIngressRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AuthorizeClientVpnIngressResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AuthorizeClientVpnIngressCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AuthorizeClientVpnIngressCommand(input, context);
    };
    AuthorizeClientVpnIngressCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AuthorizeClientVpnIngressCommand(output, context);
    };
    return AuthorizeClientVpnIngressCommand;
}($Command));
export { AuthorizeClientVpnIngressCommand };
