import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AttachVolumeRequest, VolumeAttachment } from "../models/models_0";
import { deserializeAws_ec2AttachVolumeCommand, serializeAws_ec2AttachVolumeCommand } from "../protocols/Aws_ec2";
var AttachVolumeCommand = (function (_super) {
    __extends(AttachVolumeCommand, _super);
    function AttachVolumeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AttachVolumeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AttachVolumeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AttachVolumeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: VolumeAttachment.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AttachVolumeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AttachVolumeCommand(input, context);
    };
    AttachVolumeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AttachVolumeCommand(output, context);
    };
    return AttachVolumeCommand;
}($Command));
export { AttachVolumeCommand };
