import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AttachNetworkInterfaceRequest, AttachNetworkInterfaceResult } from "../models/models_0";
import { deserializeAws_ec2AttachNetworkInterfaceCommand, serializeAws_ec2AttachNetworkInterfaceCommand, } from "../protocols/Aws_ec2";
var AttachNetworkInterfaceCommand = (function (_super) {
    __extends(AttachNetworkInterfaceCommand, _super);
    function AttachNetworkInterfaceCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AttachNetworkInterfaceCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AttachNetworkInterfaceCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AttachNetworkInterfaceRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AttachNetworkInterfaceResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AttachNetworkInterfaceCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AttachNetworkInterfaceCommand(input, context);
    };
    AttachNetworkInterfaceCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AttachNetworkInterfaceCommand(output, context);
    };
    return AttachNetworkInterfaceCommand;
}($Command));
export { AttachNetworkInterfaceCommand };
