import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AttachInternetGatewayRequest } from "../models/models_0";
import { deserializeAws_ec2AttachInternetGatewayCommand, serializeAws_ec2AttachInternetGatewayCommand, } from "../protocols/Aws_ec2";
var AttachInternetGatewayCommand = (function (_super) {
    __extends(AttachInternetGatewayCommand, _super);
    function AttachInternetGatewayCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AttachInternetGatewayCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AttachInternetGatewayCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AttachInternetGatewayRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AttachInternetGatewayCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AttachInternetGatewayCommand(input, context);
    };
    AttachInternetGatewayCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AttachInternetGatewayCommand(output, context);
    };
    return AttachInternetGatewayCommand;
}($Command));
export { AttachInternetGatewayCommand };
