import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AssociateSubnetCidrBlockRequest, AssociateSubnetCidrBlockResult } from "../models/models_0";
import { deserializeAws_ec2AssociateSubnetCidrBlockCommand, serializeAws_ec2AssociateSubnetCidrBlockCommand, } from "../protocols/Aws_ec2";
var AssociateSubnetCidrBlockCommand = (function (_super) {
    __extends(AssociateSubnetCidrBlockCommand, _super);
    function AssociateSubnetCidrBlockCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AssociateSubnetCidrBlockCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AssociateSubnetCidrBlockCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AssociateSubnetCidrBlockRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AssociateSubnetCidrBlockResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AssociateSubnetCidrBlockCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AssociateSubnetCidrBlockCommand(input, context);
    };
    AssociateSubnetCidrBlockCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AssociateSubnetCidrBlockCommand(output, context);
    };
    return AssociateSubnetCidrBlockCommand;
}($Command));
export { AssociateSubnetCidrBlockCommand };
