import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AssociateRouteTableRequest, AssociateRouteTableResult } from "../models/models_0";
import { deserializeAws_ec2AssociateRouteTableCommand, serializeAws_ec2AssociateRouteTableCommand, } from "../protocols/Aws_ec2";
var AssociateRouteTableCommand = (function (_super) {
    __extends(AssociateRouteTableCommand, _super);
    function AssociateRouteTableCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AssociateRouteTableCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AssociateRouteTableCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AssociateRouteTableRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AssociateRouteTableResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AssociateRouteTableCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AssociateRouteTableCommand(input, context);
    };
    AssociateRouteTableCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AssociateRouteTableCommand(output, context);
    };
    return AssociateRouteTableCommand;
}($Command));
export { AssociateRouteTableCommand };
