import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ApplySecurityGroupsToClientVpnTargetNetworkRequest, ApplySecurityGroupsToClientVpnTargetNetworkResult, } from "../models/models_0";
import { deserializeAws_ec2ApplySecurityGroupsToClientVpnTargetNetworkCommand, serializeAws_ec2ApplySecurityGroupsToClientVpnTargetNetworkCommand, } from "../protocols/Aws_ec2";
var ApplySecurityGroupsToClientVpnTargetNetworkCommand = (function (_super) {
    __extends(ApplySecurityGroupsToClientVpnTargetNetworkCommand, _super);
    function ApplySecurityGroupsToClientVpnTargetNetworkCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ApplySecurityGroupsToClientVpnTargetNetworkCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ApplySecurityGroupsToClientVpnTargetNetworkCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ApplySecurityGroupsToClientVpnTargetNetworkRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ApplySecurityGroupsToClientVpnTargetNetworkResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ApplySecurityGroupsToClientVpnTargetNetworkCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ApplySecurityGroupsToClientVpnTargetNetworkCommand(input, context);
    };
    ApplySecurityGroupsToClientVpnTargetNetworkCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ApplySecurityGroupsToClientVpnTargetNetworkCommand(output, context);
    };
    return ApplySecurityGroupsToClientVpnTargetNetworkCommand;
}($Command));
export { ApplySecurityGroupsToClientVpnTargetNetworkCommand };
